// Copyright 2005-2017 The Mumble Developers. All rights reserved.
// Use of this source code is governed by a BSD-style license
// that can be found in the LICENSE file at the root of the
// Mumble source tree or at <https://www.mumble.info/LICENSE>.

#ifndef MUMBLE_MUMBLE_OVERLAYCONFIG_H_
#define MUMBLE_MUMBLE_OVERLAYCONFIG_H_

#include "OverlayText.h"
#include "ConfigWidget.h"

#include "ui_Overlay.h"

class OverlayUserGroup;
struct OverlayAppInfo;
class OverlayPositionableItem;

class OverlayConfig : public ConfigWidget, public Ui::OverlayConfig {
	private:
		Q_OBJECT
		Q_DISABLE_COPY(OverlayConfig)

		void initDisplay();
		void initDisplayFps();
		void initDisplayClock();
		void refreshFpsDemo();
		void refreshFpsLive();
		void refreshTimeLive();
	protected:
		QPixmap qpScreen;
		QGraphicsPixmapItem *qgpiScreen;
		QGraphicsScene qgs;
		QGraphicsScene qgsFpsPreview;
		BasepointPixmap bpFpsDemo;
		BasepointPixmap bpTimeDemo;
		QGraphicsPixmapItem *qgpiFpsDemo;
		OverlayPositionableItem *qgpiFpsLive;
		OverlayPositionableItem *qgpiTimeLive;
		OverlayUserGroup *oug;
		QGraphicsTextItem *qgtiInstructions;

		float fViewScale;

		bool eventFilter(QObject *, QEvent *) Q_DECL_OVERRIDE;

		bool supportsInstallableOverlay();
		bool isInstalled();
		bool needsUpgrade();
		bool installFiles();
		bool uninstallFiles();
		bool supportsCertificates();
		bool installerIsValid();
		void showCertificates();

		QString applicationIdentifierForPath(const QString &path);
		OverlayAppInfo applicationInfoForId(const QString &identifier);
	protected slots:
		void on_qpbInstall_clicked();
		void on_qpbUninstall_clicked();
		void on_qpbAdd_clicked();
		void on_qpbRemove_clicked();
		void on_qrbBlacklist_toggled(bool);
		void on_qcbEnable_stateChanged(int);
		void on_qcbShowFps_stateChanged(int);
		void on_qcbShowTime_stateChanged(int);
		void on_qpbFpsFont_clicked();
		void on_qpbFpsColor_clicked();
		void on_qpbLoadPreset_clicked();
		void on_qpbSavePreset_clicked();
		void resizeScene(bool force=false);
	public:
		OverlayConfig(Settings &st);
		virtual QString title() const Q_DECL_OVERRIDE;
		virtual QIcon icon() const Q_DECL_OVERRIDE;
	public slots:
		void accept() const Q_DECL_OVERRIDE;
		void save() const Q_DECL_OVERRIDE;
		void load(const Settings &r) Q_DECL_OVERRIDE;
		bool expert(bool) Q_DECL_OVERRIDE;
};

#endif
