CONFIG *= warn_on

include(buildenv.pri)

win32 {
	# Import dependency paths for windows
	include(winpaths_default.pri)

	INCLUDEPATH *= "$$BOOST_PATH/include" "$$BOOST_PATH/include/boost-1_49/"
	QMAKE_LIBDIR *= "$$OPENSSL_PATH/lib" "$$LIBSNDFILE_PATH/lib" "$$BOOST_PATH/lib"
	INCLUDEPATH *= "$$OPENSSL_PATH/include" "$$LIBSNDFILE_PATH/include"
	CONFIG(intelcpp) {
		DEFINES *= USE_INTEL_IPP
		DEFINES *= RESTRICT=restrict
		DEFINES *= VAR_ARRAYS
		QMAKE_CC = icl
		QMAKE_CXX = icl
		QMAKE_LIB = xilib /nologo
		QMAKE_LINK = xilink
		QMAKE_CFLAGS *= -Qstd=c99 -Qrestrict -Qvc9
		QMAKE_CXXFLAGS *= -Qstd=c++0x -Qrestrict -Qvc9

		QMAKE_CFLAGS_LTCG =
		QMAKE_CXXFLAGS_LTCG =
		QMAKE_LFLAGS_LTCG =

		QMAKE_CFLAGS_RELEASE *= -O3 -Ot -QxSSE2 -Qprec-div-
		QMAKE_CFLAGS_RELEASE -=-arch:SSE
		QMAKE_CFLAGS_RELEASE -= -GL

		QMAKE_CXXFLAGS_RELEASE *= -O3 -Ot -QxSSE2 -Qprec-div-
		QMAKE_CXXFLAGS_RELEASE -=-arch:SSE
		QMAKE_CXXFLAGS_RELEASE -= -GL

		QMAKE_CFLAGS_DEBUG *= -O2 -Ob0
		QMAKE_CXXFLAGS_DEBUG *= -O2 -Ob0

		CONFIG(optgen) {
			QMAKE_CFLAGS *= -Qprof-gen
			QMAKE_CXXFLAGS *= -Qprof-gen
		}

		CONFIG(optimize) {
			QMAKE_CFLAGS *= -Qprof-use
			QMAKE_CXXFLAGS *= -Qprof-use
		}
	} else {
		QMAKE_CFLAGS_RELEASE *= -Ox -Ot /fp:fast /Qfast_transcendentals -Ob2
		QMAKE_CXXFLAGS_RELEASE *= -Ox -Ot /fp:fast /Qfast_transcendentals -Ob2
		QMAKE_LFLAGS_RELEASE *= /SafeSEH /NXCOMPAT /DYNAMICBASE
		CONFIG(analyze) {
			QMAKE_CFLAGS_DEBUG *= /analyze
			QMAKE_CXXFLAGS_DEBUG *= /analyze
			QMAKE_CFLAGS_RELEASE *= /analyze
			QMAKE_CXXFLAGS_RELEASE *= /analyze
		}
		DEFINES *= RESTRICT=
		CONFIG(sse2) {
		      QMAKE_CFLAGS_RELEASE -= -arch:SSE
		      QMAKE_CFLAGS_DEBUG -= -arch:SSE
		      QMAKE_CFLAGS += -arch:SSE2
		}
	}

	CONFIG(symbols) {
		QMAKE_CFLAGS_RELEASE *= -GR -Zi -Oy-
		QMAKE_CXXFLAGS_RELEASE *= -GR -Zi -Oy-

		QMAKE_CFLAGS_RELEASE -= -Oy
		QMAKE_CXXFLAGS_RELEASE -= -Oy

		QMAKE_LFLAGS *= /debug
		QMAKE_LFLAGS *= /OPT:REF /OPT:ICF
	}

	CONFIG(vld) {
		CONFIG(debug, debug|release) {
			DEFINES *= USE_VLD
			INCLUDEPATH *= "$$VLD_PATH/include"
			QMAKE_LIBDIR *= "$$VLD_PATH/lib"
		}
	}
}

unix {
	DEFINES *= RESTRICT=__restrict__
	QMAKE_CFLAGS *= -Wfatal-errors -fvisibility=hidden
	QMAKE_CXXFLAGS *= -Wfatal-errors -fvisibility=hidden
	!CONFIG(quiet-build-log) {
		QMAKE_CFLAGS *= -Wshadow -Wconversion -Wsign-compare
		QMAKE_CXXFLAGS *= -Wshadow -Woverloaded-virtual -Wold-style-cast -Wconversion -Wsign-compare
	}

	CONFIG(opt-gcc) {
		QMAKE_CC = /opt/gcc/bin/gcc
		QMAKE_CXX = /opt/gcc/bin/g++
		QMAKE_LINK = /opt/gcc/bin/g++
	}

	CONFIG(optgen) {
		QMAKE_CFLAGS *= -O3 -march=native -ffast-math -ftree-vectorize -fprofile-generate
		QMAKE_CXXFLAGS *= -O3 -march=native -ffast-math -ftree-vectorize -fprofile-generate
		QMAKE_LFLAGS *= -fprofile-generate
	}

	CONFIG(optimize) {
		QMAKE_CFLAGS *= -O3 -march=native -ffast-math -ftree-vectorize -fprofile-use
		QMAKE_CXXFLAGS *= -O3 -march=native -ffast-math -ftree-vectorize -fprofile-use
	}

	# Note: Mumble and Murmur 1.2.x wasn't developed in C++11 mode,
	# and has not seen sufficient testing. Use this CONFIG option at
	# your own risk.
	CONFIG(c++11) {
		QMAKE_CXXFLAGS *= -std=c++11

		# Debian seems to put C++11 variants of shared libraries
		# in /usr/lib/$triple/c++11.
		#
		# At least, that is the case for ZeroC Ice.
		#
		# The expectation is that this is a general convention,
		# so add it to our library search path in C++11 mode.
		MULTIARCH_TRIPLE = $$system($${QMAKE_CXX} -print-multiarch)
		!isEmpty(MULTIARCH_TRIPLE) {
			QMAKE_LIBDIR *= /usr/lib/$${MULTIARCH_TRIPLE}/c++11
		}
	} else {
		# If C++11 support hasn't been explicitly enabled,
		# force C++03 mode. If we don't do this, newer
		# compilers (such as G++ 6) will default to C++11
		# without us being aware.
		QMAKE_CXXFLAGS *= -std=c++03
	}
}

unix:!macx {
	CONFIG(debug, debug|release) {
		QMAKE_CFLAGS *= -fstack-protector -fPIE -pie
		QMAKE_CXXFLAGS *= -fstack-protector -fPIE -pie
		QMAKE_LFLAGS = -Wl,--no-add-needed
	}

	DEFINES *= _FORTIFY_SOURCE=2
	QMAKE_LFLAGS *= -Wl,-z,relro -Wl,-z,now

	CONFIG(symbols) {
		QMAKE_CFLAGS *= -g
		QMAKE_CXXFLAGS *= -g
	}
}

macx {
	SYSTEM_INCLUDES = $$(MUMBLE_PREFIX)/include $$(MUMBLE_PREFIX)/include/boost_1_51_0 $$[QT_INSTALL_HEADERS]
	QMAKE_LIBDIR *= $$(MUMBLE_PREFIX)/lib

	for(inc, $$list($$SYSTEM_INCLUDES)) {
		QMAKE_CFLAGS += -isystem $$inc
		QMAKE_CXXFLAGS += -isystem $$inc
		QMAKE_OBJECTIVE_CFLAGS += -isystem $$inc
		QMAKE_OBJECTIVE_CXXFLAGS += -isystem $$inc
	}

	!CONFIG(universal) {
		CONFIG += no-pch
		QMAKE_MAC_SDK = $$system(xcrun --sdk macosx --show-sdk-path 2>/dev/null)
		isEmpty(QMAKE_MAC_SDK) {
			QMAKE_MAC_SDK = $$system(xcode-select --print-path)/Platforms/MacOSX.platform/Developer/SDKs/MacOSX10.8.sdk
			!exists($$QMAKE_MAC_SDK) {
				message("Unable to find usable OS X SDK")
				error("Aborting build")
			}
		}
		QMAKE_CC = $$system(xcrun -find clang)
		QMAKE_CXX = $$system(xcrun -find clang++)
		QMAKE_LINK = $$system(xcrun -find clang++)
		QMAKE_MACOSX_DEPLOYMENT_TARGET = 10.6
		QMAKE_CFLAGS += -mmacosx-version-min=10.6
		QMAKE_CXXFLAGS += -mmacosx-version-min=10.6
		QMAKE_OBJECTIVE_CFLAGS += -mmacosx-version-min=10.6
		QMAKE_OBJECTIVE_CXXFLAGS += -mmacosx-version-min=10.6
	} else {
		XCODE_PATH=$$system(xcode-select -print-path)
		CONFIG += x86 ppc no-cocoa
		QMAKE_MAC_SDK = $${XCODE_PATH}/SDKs/MacOSX10.5.sdk
		QMAKE_CC = $${XCODE_PATH}/usr/bin/gcc-4.2
		QMAKE_CXX = $${XCODE_PATH}/usr/bin/g++-4.2
		QMAKE_LINK = $${XCODE_PATH}/usr/bin/g++-4.2
		QMAKE_MACOSX_DEPLOYMENT_TARGET = 10.4
		QMAKE_CFLAGS += -mmacosx-version-min=10.4 -Xarch_i386 -mmmx -Xarch_i386 -msse -Xarch_i386 -msse2
		QMAKE_CXXFLAGS += -mmacosx-version-min=10.4 -Xarch_i386 -mmmx -Xarch_i386 -msse -Xarch_i386 -msse2
		QMAKE_OBJECTIVE_CFLAGS += -mmacosx-version-min=10.4 -Xarch_i386 -mmmx -Xarch_i386 -msse -Xarch_i386 -msse2
		QMAKE_OBJECTIVE_CXXFLAGS += -mmacosx-version-min=10.4 -Xarch_i386 -mmmx -Xarch_i386 -msse -Xarch_i386 -msse2
	}

	QMAKE_LFLAGS += -Wl,-dead_strip -framework Cocoa -framework Carbon

	CONFIG(symbols) {
		QMAKE_CFLAGS *= -gfull -gdwarf-2
		QMAKE_CXXFLAGS *= -gfull -gdwarf-2
	}
}

CONFIG(clang-analyzer) {
	QMAKE_CC = $$(CC)
	QMAKE_CXX = $$(CXX)
}

CONFIG(no-pch) {
	CONFIG -= precompile_header
} else {
 	CONFIG *= precompile_header
}

CONFIG(debug, debug|release) {
	DEFINES *= SNAPSHOT_BUILD
}
